<?php
defined('_JEXEC') or die( 'Direct Access to ' . basename( __FILE__ ) . ' is not allowed.' ) ;

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

//ini_set('error_reporting', E_ALL );
//ini_set('display_errors', true );

if (!class_exists('vmCustomPlugin')) {
	require JPATH_VM_PLUGINS . '/vmcustomplugin.php';
}
if (!class_exists('vmPSPlugin')) {
	require JPATH_VM_PLUGINS . '/vmpsplugin.php';
}


class plgVmPaymentSMSPILOT extends vmPSPlugin
{

    public function plgVmConfirmedOrder($cart, $order)
    {
		$o = $order['details']['BT'];

		if ( ($p = $this->params->get('vendor_phone')) && ($msg = $this->params->get('vendor_msg')) ) {
			// $currency = CurrencyDisplay::getInstance();
			$msg = str_replace(
				array('%s', '%n'),
//				array($currency->priceDisplay($o->order_total), $o->order_number),
				array( round($o->order_total,2), $o->order_number),
				$msg);

			$this->sms($p, $msg);
		}
		// hack for pending shopper SMS
		if ( strpos( $this->params->get('shopper_status_conf'), 'P' ) !== false ) {
			if (($p = $this->_getShopperPhone($o)) && ($msg = $this->params->get('shopper_msg'))) {
				$msg = str_replace(
					array('%s', '%n'),
					array(round($o->order_total, 2), $o->order_number),
					$msg);
				$this->sms($p, $msg);
			}
		}
    }

	public function plgVmOnUpdateOrderPayment($order, $old_order_status)
	{

		$statusModel = VmModel::getModel('orderstatus');
		$statuses = $statusModel->getOrderStatusNames( false );

		$status = $order->order_status;
		$status_name = JText::_( $statuses[ $status ]['order_status_name'] );

		// sms to vendor
		if ( ($vp = $this->params->get('vendor_phone') ) && ( !isset($_POST['task']) || $_POST['task'] !== 'updatestatus' )) {

			if ( ($vs = $this->params->get('vendor_statuses'))
				&& (strpos($vs, $status) !== false)
				&& ($msg = $this->params->get('vendor_msg2')))
			{

				$msg = str_replace(
					array('%s','%n'),
					array($status_name,$order->order_number),
					$msg);
				$this->sms($vp, $msg);
			}
		}
		// sms to shopper
		$orderModel = VmModel::getModel('orders');
		$o = $orderModel->getOrder($order->virtuemart_order_id);
		$o = $o['details']['BT'];
		$p = $this->_getShopperPhone( $o );
		// confirmed ?
		$status_conf = $this->params->get('shopper_status_conf');

		if ( strpos( $o->order_status, $status_conf) === false && strpos( $order->order_status, $status_conf) !== false ) {
			if ($msg = $this->params->get('shopper_msg')) {
//				$currency = CurrencyDisplay::getInstance();
//				$s = $currency->priceDisplay( $o->order_total );
				$s = round( $o->order_total, 2);
				if ( !empty($_POST['comments']) ) {
					$s .= ' '.$_POST['comments'];
				}
				$msg = str_replace(
					array('%s','%n'),

					array( $s,$o->order_number),
					$msg);
				$this->sms( $p, $msg );
			}
		} else if ( ($ss = $this->params->get('shopper_statuses'))
			&& (strpos($ss, $status) !== false)
			&& ($msg = $this->params->get('shopper_msg2')) )
		{
			$s = $status_name;
			if ( !empty($_POST['comments']) ) {
				$s .= ' '.$_POST['comments'];
			}

			$msg = str_replace(
				array('%s','%n'),
				array($s, $order->order_number ),
				$msg);
			$this->sms($p, $msg);
		}
	}
	/*
	 * @link http://www.smspilot.ru/apikey.php
	 **/
	public function sms( $phone, $text  ) {

//		return file_put_contents( __DIR__ .'/sms.txt', "\r\n".$text, FILE_APPEND );
		$url = 'http://smspilot.ru/api.php'
			.'?send='.urlencode( $text )
			.'&to='.$phone
			.'&from='.$this->params->get('sender')
			.'&apikey='.$this->params->get('apikey')
			.'&source=6'
			.'&format=json';

		$ch = curl_init( $url );
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$json = curl_exec($ch);

		if ( $json && ($j = json_decode($json, true)) && empty($j['error']) ) {
			return $j['send'][0]['server_id'];
		}
		return false;
	}
	private function _getShopperPhone( $o )
	{
		$p = $o->phone_1;
		$p = preg_replace('/\D/','', $p);
		if ( strlen($p)<10 ){
			$p = $o->phone_2;
			$p = preg_replace('/\D/','', $p);
			if ( strlen($p) < 10 ) {
				return false;
			}
		}
		return $p;
	}
}
