<?php

class JFormRuleSMSPILOTAPIKEY extends JFormRule {
	public function test( $element, $value, $group = NULL, $input = NULL, $form = NULL)
	{
		ini_set('error_reporting', E_ALL );
		ini_set('display_errors', true );

		/* @var $form JForm
		 * @var $input JInput
		 */
		$app = JFactory::getApplication();

		$apikey = $input->get('params.apikey');
		$vendor_phone = $input->get('params.vendor_phone');

		if ( !preg_match('/^[A-Z0-9]{64}$/', $apikey ) ) {
			$element->addAttribute( 'message', 'API-ключ должен быть строкой из 64 символов, скопируйте его из настроек в <a href="https://www.smspilot.ru/my-settings.php#api" target="_blank">личном кабинете</a> SMSPILOT.RU!' );
			return false;
		}
		if ( $vendor_phone !== '' && !preg_match( '/^\d+$/', $vendor_phone ) ) {
			$element->addAttribute( 'message', 'Телефон продавца должен быть правильным!' );
			return false;
		}
		$tpl_error = 'Сервер SMSPILOT.RU вернул ошибку: <pre>%s</pre>Попробуйте найти способ решения проблемы в  разделе <a href="http://www.smspilot.ru/faq.php" target="_blank">Вопрос-Ответ</a> или обратитесь в <a href="https://www.smspilot.ru/support.php" target="_blank">службу поддержки</a> SMSPILOT.RU';

		$url = 'http://smspilot.ru/api.php?apikey=' . $apikey. '&source=6&format=json';

		$ch = curl_init( $url );
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$json = curl_exec($ch);
		curl_close($ch);

		if ( $json ) {
			if ( $j = json_decode( $json, true ) ) {
				if ( isset( $j['error'] ) ) {
					$app->enqueueMessage( sprintf( $tpl_error, $j['error']['description_ru']), 'warning' );
					return false;
				}
			} else {
				$app->enqueueMessage( 'Ошибка JSON: '.$json.' URL: '.$url, 'warning' );
				return false;
			}
			$app->enqueueMessage( 'Номер договора: <b>'.$j['id'].'</b><br/>Баланс: <b>'.$j['balance'].'</b>' );
		} else {
			$app->enqueueMessage( 'Ошибка соединения с сервером: '.$url, 'warning' );
			ob_start();
			ini_set('html_errors', false);
			phpinfo();
			$phpinfo = strip_tags( ob_get_clean());
			$app->enqueueMessage( '<pre>'.$phpinfo.'</pre>','warning' );
		}
		if ( isset( $_POST['test_vendor'] )) {
			$vendor_msg = $_POST['jform']['params']['vendor_msg'];
			$vendor_msg = str_replace(
				[ '%s', '%n' ],
				[ round( mt_rand( 10000, 100000 ) / 100, 2 ), mt_rand( 1000, 9999 ) ],
				$vendor_msg );
			$msg = 'Тестовое сообщение продавцу +'.$vendor_phone.': '.$vendor_msg.'<br/>';
			$url = 'http://smspilot.ru/api.php'
			       . '?send=' . urlencode( $vendor_msg )
			       . '&to=' . urlencode( $vendor_phone )
			       . '&apikey=' . $apikey
			       . '&source=6&format=json';

			$ch = curl_init( $url );
			curl_setopt($ch, CURLOPT_HEADER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$json = curl_exec($ch);
			curl_close($ch);

			if ( $json ) {
				if ( $j = json_decode( $json, true ) ) {
					if ( isset( $j['error'] ) ) {
						$app->enqueueMessage( $msg . sprintf( $tpl_error, $j['error']['description_ru'] ), 'warning' );
					} else {
						$app->enqueueMessage( $msg . 'Ответ сервера: <pre>' . $json . '</pre>' );
					}
				} else {
					$app->enqueueMessage( 'Ошибка JSON: ' . $json, 'warning' );
				}
			} else {
				$app->enqueueMessage( 'Ошибка соединения с сервером: '.$url, 'warning' );
			}
		}
		if ( isset( $_POST['test_shopper']) ) {
			$shopper_msg = $_POST['jform']['params']['shopper_msg'];
			$shopper_msg = str_replace(
				[ '%s', '%n' ],
				[ round( mt_rand( 10000, 100000 ) / 100, 2 ), mt_rand( 1000, 9999 ) ],
				$shopper_msg );

			$msg = 'Тестовое сообщение покупателю +'.$vendor_phone.': ' . $shopper_msg . '<br/>';
			$url = 'http://smspilot.ru/api.php'
			       . '?send=' . urlencode( $shopper_msg )
			       . '&to=' . urlencode( $vendor_phone )
			       . '&apikey=' . $apikey
			       . '&source=6&format=json';

//			$json = file_get_contents( $url );
			$ch = curl_init( $url );
			curl_setopt($ch, CURLOPT_HEADER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$json = curl_exec($ch);
			if ( $json ) {
				if ( $j = json_decode( $json, true ) ) {
					if ( isset( $j['error'] ) ) {
						$app->enqueueMessage( $msg . sprintf( $tpl_error, $j['error']['description_ru'] ), 'warning' );
					} else {
						$app->enqueueMessage( $msg . 'Ответ сервера: <pre>' . $json . '</pre>' );
					}
				} else {
					$app->enqueueMessage( 'Ошибка JSON: ' . $json, 'warning' );
				}
			} else {
				$app->enqueueMessage( 'Ошибка соединения с сервером: '.$url, 'warning' );
			}
		}

		return true;
	}
}
